/*
 * Decompiled with CFR 0.152.
 */
package com.redpxnda.respawnobelisks.data.saved;

import com.redpxnda.nucleus.util.PlayerUtil;
import com.redpxnda.respawnobelisks.config.TeleportConfig;
import com.redpxnda.respawnobelisks.mixin.LivingEntityAccessor;
import com.redpxnda.respawnobelisks.network.ModPackets;
import com.redpxnda.respawnobelisks.network.PlayLocalSoundPacket;
import com.redpxnda.respawnobelisks.network.RuneCirclePacket;
import com.redpxnda.respawnobelisks.registry.block.RespawnObeliskBlock;
import com.redpxnda.respawnobelisks.registry.block.entity.RespawnObeliskBlockEntity;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class RuneCircle {
    public int tick;
    public int idleTick = 0;
    public final int maxTick = 100;
    public final UUID playerUUID;
    private final ItemStack item;
    public final BlockPos pos;
    public final BlockPos target;
    public final Vec3 startPos;
    public boolean stopped = false;

    public RuneCircle(ServerLevel level, int tick, UUID player, CompoundTag stack, BlockPos pos, BlockPos target, double x, double y, double z) {
        this.tick = tick;
        this.playerUUID = player;
        this.item = ItemStack.m_41712_((CompoundTag)stack);
        this.pos = pos;
        RespawnObeliskBlockEntity blockEntity = (RespawnObeliskBlockEntity)level.m_7702_(pos);
        blockEntity.hasTeleportingEntity = true;
        blockEntity.syncWithClient();
        this.target = target;
        this.startPos = new Vec3(x, y, z);
    }

    public RuneCircle(ServerLevel level, int tick, UUID player, ItemStack stack, BlockPos pos, BlockPos target, double x, double y, double z) {
        this.tick = tick;
        this.playerUUID = player;
        this.item = stack;
        this.pos = pos;
        RespawnObeliskBlockEntity blockEntity = (RespawnObeliskBlockEntity)level.m_7702_(pos);
        blockEntity.hasTeleportingEntity = true;
        blockEntity.syncWithClient();
        this.target = target;
        this.startPos = new Vec3(x, y, z);
    }

    public RuneCircle(ServerLevel level, ServerPlayer player, ItemStack stack, BlockPos pos, BlockPos target, double x, double y, double z) {
        this(level, 0, player.m_20148_(), stack, pos, target, x, y, z);
        List players = level.m_8795_(p -> this.getAABB().m_82393_(p.m_20185_(), p.m_20186_(), p.m_20189_()));
        ModPackets.CHANNEL.sendToPlayers((Iterable)players, (Object)new PlayLocalSoundPacket(SoundEvents.f_11736_, 1.0f, 1.0f, x, y, z));
        ModPackets.CHANNEL.sendToPlayers((Iterable)players, (Object)new RuneCirclePacket(false, this.tick, x, y, z));
    }

    public AABB getAABB() {
        return AABB.m_82321_((BoundingBox)new BoundingBox((int)this.startPos.f_82479_ - 10, (int)this.startPos.f_82480_ - 10, (int)this.startPos.f_82481_ - 10, (int)this.startPos.f_82479_ + 10, (int)this.startPos.f_82480_ + 10, (int)this.startPos.f_82481_ + 10));
    }

    public CompoundTag save(CompoundTag tag) {
        tag.m_128405_("Tick", this.tick);
        tag.m_128362_("Player", this.playerUUID);
        tag.m_128365_("Item", (Tag)this.item.m_41739_(new CompoundTag()));
        tag.m_128385_("ObeliskPos", new int[]{this.pos.m_123341_(), this.pos.m_123342_(), this.pos.m_123343_()});
        tag.m_128385_("TeleportPos", new int[]{this.target.m_123341_(), this.target.m_123342_(), this.target.m_123343_()});
        ListTag list = new ListTag();
        list.add((Object)DoubleTag.m_128500_((double)this.startPos.f_82479_));
        list.add((Object)DoubleTag.m_128500_((double)this.startPos.f_82480_));
        list.add((Object)DoubleTag.m_128500_((double)this.startPos.f_82481_));
        tag.m_128365_("StartPos", (Tag)list);
        return tag;
    }

    public static RuneCircle fromNbt(ServerLevel level, CompoundTag tag) {
        UUID player = tag.m_128342_("Player");
        int[] ints = tag.m_128465_("ObeliskPos");
        BlockPos obeliskPos = new BlockPos(ints[0], ints[1], ints[2]);
        ints = tag.m_128465_("TeleportPos");
        BlockPos teleportPos = new BlockPos(ints[0], ints[1], ints[2]);
        ListTag startPosList = tag.m_128437_("StartPos", 6);
        double x = startPosList.m_128772_(0);
        double y = startPosList.m_128772_(1);
        double z = startPosList.m_128772_(2);
        return new RuneCircle(level, tag.m_128451_("Tick"), player, tag.m_128469_("Item"), obeliskPos, teleportPos, x, y, z);
    }

    public void tick(ServerLevel level) {
        PlayerList list = level.m_7654_().m_6846_();
        if (list.m_11259_(this.playerUUID) == null || list.m_11259_(this.playerUUID).m_213877_()) {
            if (this.idleTick++ >= 200) {
                this.stop(level);
            }
            return;
        }
        ServerPlayer player = list.m_11259_(this.playerUUID);
        if (player.m_20185_() != this.startPos.f_82479_ || player.m_20186_() != this.startPos.f_82480_ || player.m_20189_() != this.startPos.f_82481_ || PlayerUtil.getTotalXp((Player)player) < TeleportConfig.xpCost || player.f_36078_ < TeleportConfig.levelCost || player.m_21205_() != this.item) {
            player.m_36335_().m_41524_(this.item.m_41720_(), TeleportConfig.teleportationBackupCooldown);
            player.m_240418_((Component)Component.m_237115_((String)"text.respawnobelisks.wormhole_closed"), true);
            this.stop(level);
            return;
        }
        List players = level.m_8795_(p -> this.getAABB().m_82393_(p.m_20185_(), p.m_20186_(), p.m_20189_()));
        ModPackets.CHANNEL.sendToPlayers((Iterable)players, (Object)new RuneCirclePacket(false, this.tick, this.startPos.f_82479_, this.startPos.f_82480_, this.startPos.f_82481_));
        if (this.tick++ >= 100) {
            this.stopped = true;
            this.execute(level, player);
        }
    }

    private void stop(ServerLevel level) {
        List players = level.m_8795_(p -> this.getAABB().m_82393_(p.m_20185_(), p.m_20186_(), p.m_20189_()));
        ModPackets.CHANNEL.sendToPlayers((Iterable)players, (Object)new PlayLocalSoundPacket(SoundEvents.f_11738_, 1.0f, 1.0f, this.startPos.f_82479_, this.startPos.f_82480_, this.startPos.f_82481_));
        ModPackets.CHANNEL.sendToPlayers((Iterable)players, (Object)new RuneCirclePacket(true, 80, this.startPos.f_82479_, this.startPos.f_82480_, this.startPos.f_82481_));
        this.stopped = true;
        BlockEntity blockEntity = level.m_7702_(this.pos);
        if (blockEntity instanceof RespawnObeliskBlockEntity) {
            RespawnObeliskBlockEntity be = (RespawnObeliskBlockEntity)blockEntity;
            be.hasTeleportingEntity = false;
        }
    }

    public void execute(ServerLevel level, ServerPlayer player) {
        RespawnObeliskBlockEntity blockEntity = (RespawnObeliskBlockEntity)level.m_7702_(this.pos);
        if (blockEntity == null) {
            return;
        }
        RespawnObeliskBlock block = (RespawnObeliskBlock)level.m_8055_(this.pos).m_60734_();
        player.m_36335_().m_41524_(player.m_21205_().m_41720_(), TeleportConfig.teleportationCooldown);
        if (TeleportConfig.xpCost > 0) {
            player.m_6756_(-TeleportConfig.xpCost);
        }
        if (TeleportConfig.levelCost > 0) {
            player.m_6749_(-TeleportConfig.levelCost);
        }
        if (TeleportConfig.dropCompassOnTp) {
            player.m_7197_(player.m_21205_(), true, true);
            player.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        }
        if (!player.m_150110_().f_35937_ && TeleportConfig.dropItemsOnTeleport) {
            ((LivingEntityAccessor)player).dropEverything(DamageSource.f_19317_);
            player.m_9174_(0);
            player.m_8985_(0);
        }
        player.m_6021_((double)this.target.m_123341_() + 0.5, (double)this.target.m_123342_(), (double)this.target.m_123343_() + 0.5);
        blockEntity.restoreSavedItems((Player)player);
        block.getRespawnLocation(true, true, TeleportConfig.forcedCurseOnTp, blockEntity.m_58900_(), this.pos, level, player);
        blockEntity.hasTeleportingEntity = false;
        blockEntity.syncWithClient();
    }

    public String toString() {
        return "RuneCircle{tick=" + this.tick + ", maxTick=100, playerUUID=" + this.playerUUID + ", pos=" + this.pos + ", target=" + this.target + ", startPos=" + this.startPos + ", stopped=" + this.stopped + "}";
    }
}

